<?php
header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Cache-Control: no-cache, no-store, must-revalidate');

$configFile = __DIR__ . '/data/config.json';
$analyticsFile = __DIR__ . '/data/analytics.json';

$action = $_GET['action'] ?? '';

switch ($action) {
    case 'get_config':
        if (file_exists($configFile)) {
            $config = json_decode(file_get_contents($configFile), true);
            echo json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Config file not found']);
        }
        break;
        
    case 'track_visit':
        $analytics = [];
        if (file_exists($analyticsFile)) {
            $analytics = json_decode(file_get_contents($analyticsFile), true);
        }
        
        $today = date('Y-m-d');
        $lastDate = $analytics['last_visit_date'] ?? '';
        
        if ($lastDate !== $today) {
            $analytics['today_visits'] = 0;
        }
        
        $analytics['total_visits'] = ($analytics['total_visits'] ?? 0) + 1;
        $analytics['today_visits'] = ($analytics['today_visits'] ?? 0) + 1;
        $analytics['last_visit_date'] = $today;
        
        $visitor = [
            'ip' => $_SERVER['REMOTE_ADDR'] ?? 'Unknown',
            'device' => $_GET['device'] ?? ($_SERVER['HTTP_USER_AGENT'] ?? 'Unknown'),
            'time' => date('Y-m-d H:i:s')
        ];
        
        if (!isset($analytics['visitors'])) {
            $analytics['visitors'] = [];
        }
        
        array_push($analytics['visitors'], $visitor);
        
        if (count($analytics['visitors']) > 100) {
            $analytics['visitors'] = array_slice($analytics['visitors'], -100);
        }
        
        file_put_contents($analyticsFile, json_encode($analytics, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        
        echo json_encode(['success' => true, 'message' => 'Visit tracked']);
        break;
        
    case 'get_analytics':
        if (file_exists($analyticsFile)) {
            $analytics = json_decode(file_get_contents($analyticsFile), true);
            echo json_encode($analytics, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        } else {
            echo json_encode([
                'total_visits' => 0,
                'today_visits' => 0,
                'last_visit_date' => '',
                'visitors' => []
            ], JSON_PRETTY_PRINT);
        }
        break;
        
    default:
        if (file_exists($configFile)) {
            $config = json_decode(file_get_contents($configFile), true);
            echo json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid action or config not found']);
        }
        break;
}
?>
