<?php
session_start();
header('Cache-Control: no-cache, no-store, must-revalidate');
header('Pragma: no-cache');
header('Expires: 0');

if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time']) > 3600) {
    session_destroy();
    header('Location: login.php');
    exit;
}

if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: login.php');
    exit;
}

if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
$csrfToken = $_SESSION['csrf_token'];

function validateCsrfToken($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

$configFile = __DIR__ . '/data/config.json';
$analyticsFile = __DIR__ . '/data/analytics.json';

$config = json_decode(file_get_contents($configFile), true);
$analytics = json_decode(file_get_contents($analyticsFile), true);

$message = '';
$messageType = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $postedToken = $_POST['csrf_token'] ?? '';
    if (!validateCsrfToken($postedToken)) {
        $message = 'নিরাপত্তা টোকেন মেলেনি। পেজ রিফ্রেশ করে আবার চেষ্টা করুন।';
        $messageType = 'error';
    } elseif (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'send_notification':
                $title = $_POST['notification_title'] ?? '';
                $body = $_POST['notification_body'] ?? '';
                
                if (!empty($title) && !empty($body)) {
                    $notificationUrl = "https://systemtamim.top/App/send_notification.php?title=" . urlencode($title) . "&body=" . urlencode($body);
                    
                    $ch = curl_init();
                    curl_setopt($ch, CURLOPT_URL, $notificationUrl);
                    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
                    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                    $response = curl_exec($ch);
                    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
                    curl_close($ch);
                    
                    if ($httpCode == 200) {
                        $message = 'নোটিফিকেশন সফলভাবে পাঠানো হয়েছে!';
                        $messageType = 'success';
                    } else {
                        $message = 'নোটিফিকেশন পাঠাতে সমস্যা হয়েছে। আবার চেষ্টা করুন।';
                        $messageType = 'error';
                    }
                } else {
                    $message = 'টাইটেল এবং বডি উভয়ই প্রয়োজন!';
                    $messageType = 'error';
                }
                break;
                
            case 'update_config':
                $config['versionCode'] = intval($_POST['versionCode'] ?? 1);
                $config['apkUrl'] = $_POST['apkUrl'] ?? '';
                $config['updateType'] = $_POST['updateType'] ?? 'optional';
                $config['message'] = $_POST['message'] ?? '';
                $config['forceClose'] = isset($_POST['forceClose']) && ($_POST['forceClose'] === 'on' || $_POST['forceClose'] === '1');
                $config['ad_enabled'] = isset($_POST['ad_enabled']) && ($_POST['ad_enabled'] === 'on' || $_POST['ad_enabled'] === '1');
                $config['ad_blocker'] = isset($_POST['ad_blocker']) && ($_POST['ad_blocker'] === 'on' || $_POST['ad_blocker'] === '1');
                $config['clicks_per_ad'] = intval($_POST['clicks_per_ad'] ?? 5);
                $config['interstitial_id'] = $_POST['interstitial_id'] ?? '';
                
                if (file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
                    $message = 'কনফিগারেশন সফলভাবে আপডেট হয়েছে!';
                    $messageType = 'success';
                } else {
                    $message = 'কনফিগারেশন সেভ করতে সমস্যা হয়েছে!';
                    $messageType = 'error';
                }
                break;
        }
    }
}

$page = $_GET['page'] ?? 'dashboard';
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>টিক টক ভিডিও ডাউনলোডার - অ্যাডমিন প্যানেল</title>
    <link rel="icon" type="image/svg+xml" href="favicon.svg">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>
    <nav class="sidebar">
        <div class="sidebar-header">
            <h2><i class="fab fa-tiktok"></i> <span>টিক টক ডাউনলোডার</span></h2>
        </div>
        <ul class="nav-menu">
            <li>
                <a href="?page=dashboard" class="<?= $page === 'dashboard' ? 'active' : '' ?>">
                    <i class="fas fa-home"></i>
                    <span>ড্যাশবোর্ড</span>
                </a>
            </li>
            <li>
                <a href="?page=notification" class="<?= $page === 'notification' ? 'active' : '' ?>">
                    <i class="fas fa-bell"></i>
                    <span>নোটিফিকেশন</span>
                </a>
            </li>
            <li>
                <a href="?page=config" class="<?= $page === 'config' ? 'active' : '' ?>">
                    <i class="fas fa-cog"></i>
                    <span>অ্যাপ সেটিংস</span>
                </a>
            </li>
            <li>
                <a href="?page=ads" class="<?= $page === 'ads' ? 'active' : '' ?>">
                    <i class="fas fa-ad"></i>
                    <span>অ্যাড সেটিংস</span>
                </a>
            </li>
            <li>
                <a href="?page=analytics" class="<?= $page === 'analytics' ? 'active' : '' ?>">
                    <i class="fas fa-chart-bar"></i>
                    <span>অ্যানালিটিক্স</span>
                </a>
            </li>
            <li style="margin-top: 30px; border-top: 1px solid var(--border-color); padding-top: 15px;">
                <a href="?logout=1" style="color: #ff5252;">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>লগআউট</span>
                </a>
            </li>
        </ul>
    </nav>

    <main class="main-content">
        <?php if (!empty($message)): ?>
        <div class="alert alert-<?= $messageType ?>" style="display: block;">
            <i class="fas fa-<?= $messageType === 'success' ? 'check-circle' : 'exclamation-circle' ?>"></i>
            <?= htmlspecialchars($message) ?>
        </div>
        <?php endif; ?>

        <?php if ($page === 'dashboard'): ?>
        <div class="page-header">
            <h1>ড্যাশবোর্ড</h1>
            <p>আপনার অ্যাপের সামগ্রিক অবস্থা দেখুন</p>
        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="stat-card">
                    <i class="fas fa-users"></i>
                    <h4><?= number_format($analytics['total_visits'] ?? 0) ?></h4>
                    <p>মোট ভিজিটর</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <i class="fas fa-calendar-day"></i>
                    <h4><?= number_format($analytics['today_visits'] ?? 0) ?></h4>
                    <p>আজকের ভিজিটর</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card">
                    <i class="fas fa-code-branch"></i>
                    <h4>v<?= $config['versionCode'] ?></h4>
                    <p>বর্তমান ভার্সন</p>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-info-circle"></i>
                        <h3>অ্যাপ স্ট্যাটাস</h3>
                    </div>
                    <table>
                        <tr>
                            <td>আপডেট টাইপ</td>
                            <td>
                                <span class="badge <?= $config['updateType'] === 'force' ? 'badge-danger' : 'badge-success' ?>">
                                    <?= $config['updateType'] === 'force' ? 'জোরপূর্বক' : 'ঐচ্ছিক' ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>অ্যাড</td>
                            <td>
                                <span class="badge <?= $config['ad_enabled'] ? 'badge-success' : 'badge-danger' ?>">
                                    <?= $config['ad_enabled'] ? 'সক্রিয়' : 'নিষ্ক্রিয়' ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>অ্যাড ব্লকার</td>
                            <td>
                                <span class="badge <?= $config['ad_blocker'] ? 'badge-warning' : 'badge-success' ?>">
                                    <?= $config['ad_blocker'] ? 'সক্রিয়' : 'নিষ্ক্রিয়' ?>
                                </span>
                            </td>
                        </tr>
                        <tr>
                            <td>ফোর্স ক্লোজ</td>
                            <td>
                                <span class="badge <?= $config['forceClose'] ? 'badge-danger' : 'badge-success' ?>">
                                    <?= $config['forceClose'] ? 'হ্যাঁ' : 'না' ?>
                                </span>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <i class="fas fa-download"></i>
                        <h3>APK তথ্য</h3>
                    </div>
                    <table>
                        <tr>
                            <td>APK লিংক</td>
                            <td style="word-break: break-all; font-size: 0.85rem;"><?= htmlspecialchars($config['apkUrl']) ?></td>
                        </tr>
                        <tr>
                            <td>আপডেট মেসেজ</td>
                            <td><?= htmlspecialchars($config['message']) ?></td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>

        <?php elseif ($page === 'notification'): ?>
        <div class="page-header">
            <h1>নোটিফিকেশন পাঠান</h1>
            <p>আপনার অ্যাপের সকল ইউজারদের কাছে নোটিফিকেশন পাঠান</p>
        </div>

        <div class="card">
            <div class="card-header">
                <i class="fas fa-paper-plane"></i>
                <h3>নতুন নোটিফিকেশন</h3>
            </div>
            <form method="POST" action="">
                <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrfToken) ?>">
                <input type="hidden" name="action" value="send_notification">
                <div class="form-group">
                    <label for="notification_title">নোটিফিকেশন টাইটেল</label>
                    <input type="text" class="form-control" id="notification_title" name="notification_title" placeholder="এখানে টাইটেল লিখুন..." required>
                </div>
                <div class="form-group">
                    <label for="notification_body">নোটিফিকেশন বডি</label>
                    <textarea class="form-control" id="notification_body" name="notification_body" placeholder="এখানে মেসেজ লিখুন..." required></textarea>
                </div>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-paper-plane"></i>
                    নোটিফিকেশন পাঠান
                </button>
            </form>
        </div>

        <?php elseif ($page === 'config'): ?>
        <div class="page-header">
            <h1>অ্যাপ সেটিংস</h1>
            <p>আপনার অ্যাপের কনফিগারেশন এখান থেকে পরিবর্তন করুন</p>
        </div>

        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrfToken) ?>">
            <input type="hidden" name="action" value="update_config">
            
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-code-branch"></i>
                            <h3>ভার্সন সেটিংস</h3>
                        </div>
                        <div class="form-group">
                            <label for="versionCode">ভার্সন কোড</label>
                            <input type="number" class="form-control" id="versionCode" name="versionCode" value="<?= $config['versionCode'] ?>" min="1">
                        </div>
                        <div class="form-group">
                            <label for="updateType">আপডেট টাইপ</label>
                            <select class="form-control" id="updateType" name="updateType">
                                <option value="optional" <?= $config['updateType'] === 'optional' ? 'selected' : '' ?>>ঐচ্ছিক (Optional)</option>
                                <option value="force" <?= $config['updateType'] === 'force' ? 'selected' : '' ?>>জোরপূর্বক (Force)</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <i class="fas fa-download"></i>
                            <h3>APK সেটিংস</h3>
                        </div>
                        <div class="form-group">
                            <label for="apkUrl">APK ডাউনলোড লিংক</label>
                            <input type="url" class="form-control" id="apkUrl" name="apkUrl" value="<?= htmlspecialchars($config['apkUrl']) ?>" placeholder="https://example.com/app.apk">
                        </div>
                        <div class="form-group">
                            <label for="message">আপডেট মেসেজ</label>
                            <textarea class="form-control" id="message" name="message" placeholder="ইউজারদের জন্য আপডেট মেসেজ..."><?= htmlspecialchars($config['message']) ?></textarea>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <i class="fas fa-toggle-on"></i>
                    <h3>অন্যান্য অপশন</h3>
                </div>
                <div class="switch-container">
                    <label for="forceClose">ফোর্স ক্লোজ (অ্যাপ জোর করে বন্ধ করুন)</label>
                    <label class="switch">
                        <input type="checkbox" id="forceClose" name="forceClose" <?= $config['forceClose'] ? 'checked' : '' ?>>
                        <span class="slider"></span>
                    </label>
                </div>
                
                <input type="hidden" name="ad_enabled" value="<?= $config['ad_enabled'] ? '1' : '' ?>">
                <input type="hidden" name="ad_blocker" value="<?= $config['ad_blocker'] ? '1' : '' ?>">
                <input type="hidden" name="clicks_per_ad" value="<?= $config['clicks_per_ad'] ?>">
                <input type="hidden" name="interstitial_id" value="<?= htmlspecialchars($config['interstitial_id']) ?>">
            </div>

            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i>
                সেটিংস সেভ করুন
            </button>
        </form>

        <?php elseif ($page === 'ads'): ?>
        <div class="page-header">
            <h1>অ্যাড সেটিংস</h1>
            <p>আপনার অ্যাপের বিজ্ঞাপন কনফিগারেশন</p>
        </div>

        <form method="POST" action="">
            <input type="hidden" name="csrf_token" value="<?= htmlspecialchars($csrfToken) ?>">
            <input type="hidden" name="action" value="update_config">
            
            <input type="hidden" name="versionCode" value="<?= $config['versionCode'] ?>">
            <input type="hidden" name="apkUrl" value="<?= htmlspecialchars($config['apkUrl']) ?>">
            <input type="hidden" name="updateType" value="<?= $config['updateType'] ?>">
            <input type="hidden" name="message" value="<?= htmlspecialchars($config['message']) ?>">
            <?php if ($config['forceClose']): ?>
            <input type="hidden" name="forceClose" value="1">
            <?php endif; ?>
            
            <div class="card">
                <div class="card-header">
                    <i class="fas fa-toggle-on"></i>
                    <h3>অ্যাড কন্ট্রোল</h3>
                </div>
                <div class="switch-container">
                    <label for="ad_enabled">অ্যাড সক্রিয় করুন</label>
                    <label class="switch">
                        <input type="checkbox" id="ad_enabled" name="ad_enabled" <?= $config['ad_enabled'] ? 'checked' : '' ?>>
                        <span class="slider"></span>
                    </label>
                </div>
                <div class="switch-container">
                    <label for="ad_blocker">অ্যাড ব্লকার ডিটেকশন</label>
                    <label class="switch">
                        <input type="checkbox" id="ad_blocker" name="ad_blocker" <?= $config['ad_blocker'] ? 'checked' : '' ?>>
                        <span class="slider"></span>
                    </label>
                </div>
            </div>

            <div class="card">
                <div class="card-header">
                    <i class="fas fa-ad"></i>
                    <h3>অ্যাড কনফিগারেশন</h3>
                </div>
                <div class="form-group">
                    <label for="clicks_per_ad">প্রতি অ্যাডে ক্লিক সংখ্যা</label>
                    <input type="number" class="form-control" id="clicks_per_ad" name="clicks_per_ad" value="<?= $config['clicks_per_ad'] ?>" min="1" max="20">
                </div>
                <div class="form-group">
                    <label for="interstitial_id">Interstitial অ্যাড আইডি</label>
                    <input type="text" class="form-control" id="interstitial_id" name="interstitial_id" value="<?= htmlspecialchars($config['interstitial_id']) ?>" placeholder="ca-app-pub-xxxxx/xxxxx">
                </div>
            </div>

            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i>
                অ্যাড সেটিংস সেভ করুন
            </button>
        </form>

        <?php elseif ($page === 'analytics'): ?>
        <div class="page-header">
            <h1>অ্যানালিটিক্স</h1>
            <p>আপনার অ্যাপের ভিজিটর ডেটা দেখুন</p>
        </div>

        <div class="row">
            <div class="col-md-6">
                <div class="stat-card">
                    <i class="fas fa-users"></i>
                    <h4><?= number_format($analytics['total_visits'] ?? 0) ?></h4>
                    <p>মোট ভিজিট</p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="stat-card">
                    <i class="fas fa-calendar-day"></i>
                    <h4><?= number_format($analytics['today_visits'] ?? 0) ?></h4>
                    <p>আজকের ভিজিট</p>
                </div>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <i class="fas fa-clock"></i>
                <h3>শেষ ভিজিটের তারিখ</h3>
            </div>
            <p style="font-size: 1.2rem; padding: 10px 0;">
                <?= !empty($analytics['last_visit_date']) ? htmlspecialchars($analytics['last_visit_date']) : 'এখনো কোনো ভিজিট নেই' ?>
            </p>
        </div>

        <?php if (!empty($analytics['visitors'])): ?>
        <div class="card">
            <div class="card-header">
                <i class="fas fa-list"></i>
                <h3>সাম্প্রতিক ভিজিটর</h3>
            </div>
            <div class="table-responsive">
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>আইপি</th>
                            <th>ডিভাইস</th>
                            <th>সময়</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php 
                        $visitors = array_reverse($analytics['visitors']);
                        $count = 0;
                        foreach ($visitors as $visitor): 
                            if ($count >= 20) break;
                            $count++;
                        ?>
                        <tr>
                            <td><?= $count ?></td>
                            <td><?= htmlspecialchars($visitor['ip'] ?? 'অজানা') ?></td>
                            <td><?= htmlspecialchars($visitor['device'] ?? 'অজানা') ?></td>
                            <td><?= htmlspecialchars($visitor['time'] ?? 'অজানা') ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        <?php endif; ?>

        <?php endif; ?>
    </main>

    <script>
        setTimeout(function() {
            var alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                alert.style.display = 'none';
            });
        }, 5000);
    </script>
</body>
</html>
