<?php
// Function to check if ad-blocking DNS is active
function isAdBlockingDNS() {
    $adDomain = "doubleclick.net"; // Known ad domain
    $dnsRecords = dns_get_record($adDomain, DNS_A);

    if (empty($dnsRecords)) {
        return true; // Ad-block DNS is active
    }

    return false; // Ad-block DNS is not active
}

// Get data from the client
$input = json_decode(file_get_contents("php://input"), true);
$adBlockedClient = isset($input['adBlocked']) ? $input['adBlocked'] : false;

// Check both client-side and server-side results
$adBlockedServer = isAdBlockingDNS();

// Final decision
$response = [
    'Adoff' => $adBlockedClient || $adBlockedServer
];

header('Content-Type: application/json');
echo json_encode($response);
?>