<?php
// টার্গেট নাম্বারের পেজ URL (একটি নমুনা URL ব্যবহার করা হয়েছে)
$targetNumberUrl = "https://sms-online.co/receive-free-sms/+46 76 943 62 66"; // এখানে 12345 টার্গেট নাম্বারের ID হিসেবে ধরেছি

// cURL দিয়ে ওয়েবসাইট ডেটা ফেচ করা
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $targetNumberUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

// রেসপন্স সংগ্রহ
$response = curl_exec($ch);
curl_close($ch);

// যদি রেসপন্স আসে তাহলে প্রসেস করো
if ($response) {
    // DOMDocument ব্যবহার করে HTML প্রসেস
    $dom = new DOMDocument();
    libxml_use_internal_errors(true); // HTML এর এরর ইগনোর করা
    $dom->loadHTML($response);
    libxml_clear_errors();

    // XPath ব্যবহার করে মেসেজ টেবিল থেকে তথ্য বের করা
    $xpath = new DOMXPath($dom);
    $rows = $xpath->query("//table[@class='sms-table']//tr");

    echo "Messages for the target number:\n";
    foreach ($rows as $row) {
        $columns = $row->getElementsByTagName("td");
        if ($columns->length > 0) {
            echo "From: " . trim($columns->item(0)->nodeValue) . "\n";
            echo "Message: " . trim($columns->item(1)->nodeValue) . "\n";
            echo "Date: " . trim($columns->item(2)->nodeValue) . "\n";
            echo "--------------------------\n";
        }
    }
} else {
    echo "Failed to fetch messages for the target number.";
}
?>