<?php
header('Content-Type: application/json');

// ইনপুট টেক্সট গ্রহণ
$inputText = $_GET['text'] ?? '';
$targetLanguage = $_GET['to'] ?? 'en'; // ডিফল্ট ভাষা: ইংরেজি
$sourceLanguage = $_GET['from'] ?? 'auto'; // উৎস ভাষা (অপশনাল)

if (empty($inputText)) {
    echo json_encode(['error' => 'No text provided for translation']);
    exit;
}

// LibreTranslate API URL
$apiUrl = "https://libretranslate.com/translate";

// API কলের জন্য ডাটা প্রস্তুত
$data = [
    'q' => $inputText,
    'target' => $targetLanguage,
    'source' => $sourceLanguage,
];

// cURL ব্যবহার করে API কল
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

$response = curl_exec($ch);

// cURL ত্রুটি চেক
if (curl_errno($ch)) {
    echo json_encode(['error' => 'cURL error: ' . curl_error($ch)]);
    curl_close($ch);
    exit;
}

curl_close($ch);

// রেসপন্স ডিকোড করা এবং রিটার্ন
$responseData = json_decode($response, true);
if (isset($responseData['translatedText'])) {
    echo json_encode(['translatedText' => $responseData['translatedText']]);
} else {
    echo json_encode(['error' => 'Translation failed']);
}
?>