<?php

function sendPushNotification($title, $body, $topic = "allUsers") {
    $serviceAccountFile = 'https://shitolkar.top/api/servicetoken.json'; // Change to your file path

    // Get Access Token
    $accessToken = getAccessToken($serviceAccountFile);

    // Firebase HTTP v1 Endpoint
    $url = "https://fcm.googleapis.com/v1/projects/speedcheek-9f554/messages:send";

    // Message payload
    $payload = [
        'message' => [
            'topic' => $topic, // Topic to send message
            'notification' => [
                'title' => $title,
                'body' => $body
            ],
            'data' => [
                'extra_info' => 'Additional data can be sent here'
            ]
        ]
    ];

    // Send HTTP POST request
    $headers = [
        "Authorization: Bearer {$accessToken}",
        "Content-Type: application/json"
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));

    $result = curl_exec($ch);

    if ($result === FALSE) {
        die('FCM Send Error: ' . curl_error($ch));
    }

    curl_close($ch);

    return $result;
}

function getAccessToken($serviceAccountFile) {
    $serviceAccount = json_decode(file_get_contents($serviceAccountFile), true);

    $now = time();
    $claims = [
        'iss' => $serviceAccount['client_email'],
        'scope' => 'https://www.googleapis.com/auth/firebase.messaging',
        'aud' => $serviceAccount['token_uri'],
        'iat' => $now,
        'exp' => $now + 3600
    ];

    $header = base64_encode(json_encode(['alg' => 'RS256', 'typ' => 'JWT']));
    $payload = base64_encode(json_encode($claims));

    $signatureInput = $header . '.' . $payload;
    $signature = '';

    openssl_sign(
        $signatureInput,
        $signature,
        $serviceAccount['private_key'],
        OPENSSL_ALGO_SHA256
    );

    $jwt = $signatureInput . '.' . base64_encode($signature);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $serviceAccount['token_uri']);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'grant_type' => 'urn:ietf:params:oauth:grant-type:jwt-bearer',
        'assertion' => $jwt
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);

    $result = curl_exec($ch);
    if ($result === FALSE) {
        die('Error fetching access token: ' . curl_error($ch));
    }

    $responseData = json_decode($result, true);
    curl_close($ch);

    return $responseData['access_token'];
}

// Call the function to send a notification
$response = sendPushNotification("হ্যালো ডেভেলপার", "আমি ডেভেলপার শীতল এই অ্যাপ তৈরি করেছি  ");
echo $response;

?>
