<?php
// সিকিউরিটি হেডার
header("X-Content-Type-Options: nosniff");
header("X-Frame-Options: SAMEORIGIN");
header("X-XSS-Protection: 1; mode=block");
header("Strict-Transport-Security: max-age=31536000; includeSubDomains");
header("Content-Security-Policy: default-src 'self'; script-src 'self'");

// টোকেন ডাটাবেস ফাইল
$token_file = 'api_tokens.json';
$api_tokens = file_exists($token_file) ? json_decode(file_get_contents($token_file), true) : [];

// ফাইল সাইজ বের করার ফাংশন
function get_remote_file_size($url) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_NOBODY, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HEADER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_exec($ch);
    $file_size = curl_getinfo($ch, CURLINFO_CONTENT_LENGTH_DOWNLOAD);
    curl_close($ch);

    return $file_size;
}

// মিডিয়া ডাউনলোড করার ফাংশন
function download_media($url, $file_extension) {
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    $data = curl_exec($ch);
    curl_close($ch);

    if ($data !== false) {
        // ফাইলের MIME টাইপ সঠিকভাবে সেট করা
        $mime_type = '';
        if ($file_extension === 'mp3') {
            $mime_type = 'audio/mpeg';
        } elseif ($file_extension === 'mp4') {
            $mime_type = 'video/mp4';
        } else {
            $mime_type = mime_content_type($url); // অন্যান্য মিডিয়া ফরম্যাটের জন্য সাধারণ MIME টাইপ
        }

        header("Content-Type: $mime_type");
        header("Content-Disposition: attachment; filename=\"media.{$file_extension}\"");
        header("Content-Transfer-Encoding: binary");
        header("Content-Length: " . strlen($data));
        echo $data;
    }
    return $data;
}

// মিডিয়া ডাউনলোড রিকুয়েস্ট
if (isset($_GET['download']) && isset($_GET['media_url']) && isset($_GET['token']) && isset($_GET['file_extension'])) {
    $media_url = $_GET['media_url'];
    $token_key = $_GET['token'];
    $file_extension = $_GET['file_extension'];

    // টোকেন যাচাই
    if (!isset($api_tokens[$token_key]) || !$api_tokens[$token_key]['active']) {
        http_response_code(403); // নিষিদ্ধ (Forbidden)
        echo "Invalid or inactive token.";
        exit;
    }

    // মিডিয়া ডাউনলোড
    $media_data = download_media($media_url, $file_extension);

    if ($media_data === false) {
        http_response_code(500); // সার্ভার সমস্যা
        echo "Failed to download media.";
        exit;
    }
    exit;
}

// টোকেন যাচাই
if (!isset($_GET['token']) || !isset($api_tokens[$_GET['token']])) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid token or Unauthorized access!"
    ]);
    exit;
}

// টোকেন ডেটা
$token_key = $_GET['token'];
$token_data = &$api_tokens[$token_key]; // রেফারেন্স ব্যবহার

// যদি টোকেন নিষ্ক্রিয় থাকে
if (!$token_data['active']) {
    echo json_encode([
        "error" => true,
        "message" => "This token is no longer active."
    ]);
    exit;
}

// যদি টোকেনের সময় সীমাবদ্ধ থাকে এবং মেয়াদ উত্তীর্ণ হয়ে যায়
if (!$token_data['unlimited_time'] && time() > $token_data['expires_at']) {
    echo json_encode([
        "error" => true,
        "message" => "This token has expired."
    ]);
    exit;
}

// রিকুয়েস্ট সীমা চেক
if (!$token_data['unlimited_requests'] && $token_data['request_count'] >= $token_data['request_limit']) {
    echo json_encode([
        "error" => true,
        "message" => "Request limit exceeded for this token."
    ]);
    exit;
}

// রিকুয়েস্ট কাউন্ট বৃদ্ধি করা
$token_data['request_count']++;

// টোকেন ডাটাবেস ফাইল আপডেট করা
file_put_contents($token_file, json_encode($api_tokens, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT));

// API থেকে টিকটক লিংক নেওয়া
$tik_url = filter_input(INPUT_GET, 'tik_url', FILTER_SANITIZE_URL);

// লিংক যাচাই
if (!$tik_url || !filter_var($tik_url, FILTER_VALIDATE_URL)) {
    echo json_encode([
        "error" => true,
        "message" => "Invalid TikTok URL provided!"
    ]);
    exit;
}

// API লিংক তৈরি এবং রিকুয়েস্ট পাঠানো
$api_url = "https://tikwm.com/api/?url=" . urlencode($tik_url);
$response = @file_get_contents($api_url);

// যদি API রেসপন্স না পাওয়া যায়
if ($response === FALSE) {
    echo json_encode([
        "error" => true,
        "message" => "Failed to connect to API."
    ]);
    exit;
}

// JSON ডেটা ডিকোড করা
$data = json_decode($response, true);

// যদি "play" বা "music" কী না থাকে
if (!isset($data['data']['play']) || !isset($data['data']['music'])) {
    echo json_encode([
        "error" => true,
        "message" => "'play' or 'music' key not found in API response."
    ]);
    exit;
}

// মূল লিংক
$play_link = $data['data']['play'];
$music_link = $data['data']['music'];

// ভিডিও এবং মিউজিক সাইজ
$video_size_bytes = get_remote_file_size($play_link);
$music_size_bytes = get_remote_file_size($music_link);

$video_size_mb = round($video_size_bytes / (1024 * 1024), 2); // MB তে রূপান্তর
$music_size_mb = round($music_size_bytes / (1024 * 1024), 2); // MB তে রূপান্তর

// ডাউনলোড লিংক তৈরি করা
$video_download_link = $_SERVER['PHP_SELF'] . "?download=true&media_url=" . urlencode($play_link) . "&token=" . $token_key . "&file_extension=mp4";
$music_download_link = $_SERVER['PHP_SELF'] . "?download=true&media_url=" . urlencode($music_link) . "&token=" . $token_key . "&file_extension=mp3";

// ইমেজ ডাউনলোড লিংক এবং সাইজ প্রক্রিয়াকরণ
$download_images = [];
if (isset($data['data']['images']) && is_array($data['data']['images'])) {
    foreach ($data['data']['images'] as $image_url) {
        $image_size_bytes = get_remote_file_size($image_url);
        $image_size_mb = round($image_size_bytes / (1024 * 1024), 2); // MB তে রূপান্তর
        $download_images[] = [
            "download_link" => $_SERVER['PHP_SELF'] . "?download=true&media_url=" . urlencode($image_url) . "&token=" . $token_key . "&file_extension=jpg",
            "view_image" => $image_url, // অরজিনাল ইমেজ লিঙ্ক
            "size" => $image_size_mb . " MB"
        ];
    }
}

// যদি ইমেজ ডাউনলোড থাকে, তাহলে ভিডিও ডাউনলোড লিঙ্ক null সেট করা হবে
if (count($download_images) > 0) {
    $video_download_link = null;
}

// JSON আউটপুট তৈরি
$data['data']['video_download'] = $video_download_link; // ভিডিও লিংক
$data['data']['video_size'] = $video_size_mb . " MB";
$data['data']['music_download'] = $music_download_link;
$data['data']['music_size'] = $music_size_mb . " MB";
$data['data']['download_images'] = $download_images;

// টোকেনের সময় ও রিকোয়েস্ট তথ্য যুক্ত করা
$data['token_info'] = [
    "unlimited_time" => $token_data['unlimited_time'],
    "expires_at" => $token_data['unlimited_time'] ? "Unlimited" : date("Y-m-d H:i:s", $token_data['expires_at']),
    "unlimited_requests" => $token_data['unlimited_requests'],
    "request_limit" => $token_data['unlimited_requests'] ? "Unlimited" : $token_data['request_limit'],
    "request_count" => $token_data['request_count']
];

// JSON আউটপুট
header('Content-Type: application/json');
echo json_encode($data, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT);
?>