<?php
$jsonFile = 'users.json';
$data = json_decode(file_get_contents($jsonFile), true);
$id = $_GET['id'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data['users'][$id]['name'] = $_POST['name'];
    $data['users'][$id]['email'] = $_POST['email'];
    $data['users'][$id]['phone'] = $_POST['phone'];
    $data['users'][$id]['dob'] = $_POST['dob'];
    $data['users'][$id]['address'] = $_POST['address'];

    file_put_contents($jsonFile, json_encode($data, JSON_PRETTY_PRINT));
    header("Location: admin.php");
    exit;
}

$user = $data['users'][$id];
?>

<!DOCTYPE html>
<html>
<head>
    <title>Edit User</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-5">
    <h3>Edit User Information</h3>
    <form method="POST" class="mt-4">
        <div class="mb-3">
            <label class="form-label">Name</label>
            <input type="text" name="name" value="<?= htmlspecialchars($user['name']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Email</label>
            <input type="email" name="email" value="<?= $user['email'] ?>" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Phone</label>
            <input type="text" name="phone" value="<?= $user['phone'] ?>" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Date of Birth</label>
            <input type="date" name="dob" value="<?= $user['dob'] ?>" class="form-control" required>
        </div>
        <div class="mb-3">
            <label class="form-label">Address</label>
            <textarea name="address" class="form-control" required><?= $user['address'] ?></textarea>
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="admin.php" class="btn btn-secondary">Cancel</a>
    </form>
</div>
</body>
</html>
