<?php
header("Content-Type: application/json");

$filename = "user_data.json"; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (!file_exists($filename)) {
        echo json_encode(["message" => "File not found"]);
        exit;
    }

    $jsonData = file_get_contents($filename);
    $data = json_decode($jsonData, true);

    $index = $_POST['index'];
    $action = $_POST['action'];

    if (isset($data[$index])) {
        switch ($action) {
            case 'approve':
                $data[$index]['status'] = 'Approved';
                break;
            case 'reject':
                $data[$index]['status'] = 'Rejected';
                break;
            case 'delete':
                array_splice($data, $index, 1);
                break;
        }

        file_put_contents($filename, json_encode($data, JSON_PRETTY_PRINT));
        echo json_encode(["message" => "Action performed successfully"]);
    } else {
        echo json_encode(["message" => "User not found"]);
    }
}
?>
