// API URL where the JSON data is stored
const apiUrl = 'https://shitolkar.top/clint/AppContrall/user_data.json';

// Fetch the JSON data from the API
fetch(apiUrl)
    .then(response => response.json())
    .then(data => {
        displayDeviceInfo(data);
    })
    .catch(error => {
        console.error("Error fetching the data:", error);
    });

// Function to display device information
function displayDeviceInfo(data) {
    const deviceInfoContainer = document.getElementById('device-info');

    // Clear any existing content
    deviceInfoContainer.innerHTML = '';

    // Loop through each device data (in case of multiple devices)
    data.forEach(device => {
        const deviceDiv = document.createElement('div');
        deviceDiv.classList.add('device-info-item');

        deviceDiv.innerHTML = `
            <h2>Device Information</h2>
            <div class="info-item">
                <span>Device ID:</span> ${device.device_id}
            </div>
            <div class="info-item">
                <span>Device Model:</span> ${device.device_model}
            </div>
            <div class="info-item">
                <span>Device OS:</span> ${device.device_os}
            </div>
            <div class="info-item">
                <span>App Version:</span> ${device.app_version}
            </div>
            <div class="info-item">
                <span>Login Count:</span> ${device.login_count}
            </div>
            <div class="info-item">
                <span>Last Login:</span> ${device.last_login}
            </div>
            <div class="info-item">
                <span>Details Link:</span> <a href="https://example.com/device/${device.device_id}">View More</a>
            </div>
        `;

        deviceInfoContainer.appendChild(deviceDiv);
    });
}
