<?php
// Save Text
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $text = $_POST['policy_text'] ?? '';
    $file = 'policies.json';
    $history = [];

    if (file_exists($file)) {
        $history = json_decode(file_get_contents($file), true);
    }

    $history[] = [
        'policy_text' => $text,
        'timestamp' => date('Y-m-d H:i:s')
    ];

    file_put_contents($file, json_encode($history, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    header("Location: editor.php?success=1");
    exit;
}

$history = file_exists('policies.json') ? json_decode(file_get_contents('policies.json'), true) : [];
?>

<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <title>✍️ Editor (No Plugin)</title>
    <style>
        body {
            font-family: sans-serif;
            padding: 30px;
            background: #f4f4f4;
        }

        .editor {
            background: white;
            padding: 20px;
            border-radius: 8px;
            min-height: 300px;
            border: 1px solid #ccc;
        }

        .toolbar button {
            padding: 6px 10px;
            margin: 2px;
            font-size: 14px;
            cursor: pointer;
        }

        .btn-save {
            margin-top: 15px;
            padding: 10px 15px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
        }

        .history {
            margin-top: 40px;
            background: white;
            padding: 15px;
            border-radius: 6px;
        }

        .api-link {
            display: inline-block;
            margin-top: 20px;
            color: #007bff;
            text-decoration: none;
        }
    </style>
</head>
<body>

<h2>📋 HelpLine পলিসি Editor (Lite)</h2>

<?php if (isset($_GET['success'])): ?>
    <p style="color:green;">✅ পলিসি সেভ হয়েছে!</p>
<?php endif; ?>

<form method="post">
    <div class="toolbar">
        <button type="button" onclick="format('bold')">Bold</button>
        <button type="button" onclick="format('italic')">Italic</button>
        <button type="button" onclick="format('underline')">Underline</button>
        <button type="button" onclick="format('insertUnorderedList')">• Bullet</button>
        <button type="button" onclick="format('insertOrderedList')">1. Number</button>
        <button type="button" onclick="format('formatBlock', 'h1')">H1</button>
        <button type="button" onclick="format('formatBlock', 'h2')">H2</button>
    </div>

    <div class="editor" contenteditable="true" id="editor"></div>
    <textarea name="policy_text" id="policy_text" hidden></textarea>

    <button type="submit" class="btn-save" onclick="beforeSubmit()">💾 Save</button>
</form>

<a class="api-link" href="policy_output.json.php" target="_blank">🔗 View JSON API</a>

<div class="history">
    <h3>📜 পুরনো পলিসিগুলো</h3>
    <?php foreach (array_reverse($history) as $item): ?>
        <p><strong><?= $item['timestamp'] ?>:</strong><br><?= $item['policy_text'] ?></p><hr>
    <?php endforeach; ?>
</div>

<script>
    function format(command, value = null) {
        document.execCommand(command, false, value);
    }

    function beforeSubmit() {
        document.getElementById('policy_text').value = document.getElementById('editor').innerHTML;
    }
</script>

</body>
</html>
