<?php
$jsonFile = 'blood_donors.json';
$index = isset($_POST['index']) ? $_POST['index'] : '';
$action = isset($_POST['action']) ? $_POST['action'] : '';

if ($index !== '' && in_array($action, ['approve', 'reject', 'delete'])) {
    if (file_exists($jsonFile)) {
        $data = file_get_contents($jsonFile);
        $donors = json_decode($data, true);
        
        if (isset($donors[$index])) {
            switch ($action) {
                case 'approve':
                    $donors[$index]['status'] = 'Approved';
                    break;
                case 'reject':
                    $donors[$index]['status'] = 'Rejected';
                    break;
                case 'delete':
                    array_splice($donors, $index, 1);
                    break;
            }
            
            if (file_put_contents($jsonFile, json_encode($donors, JSON_PRETTY_PRINT))) {
                echo json_encode(["status" => "success", "message" => ucfirst($action) . " action completed"]);
            } else {
                echo json_encode(["status" => "failed", "message" => "Failed to update the data"]);
            }
        } else {
            echo json_encode(["status" => "failed", "message" => "Donor not found"]);
        }
    } else {
        echo json_encode(["status" => "failed", "message" => "File not found"]);
    }
} else {
    echo json_encode(["status" => "failed", "message" => "Invalid parameters"]);
}
?>
