<?php
// রক্তদানকারীদের JSON ফাইল পাথ
$jsonFile = 'blood_donors.json';

// সার্চ প্যারামিটার গ্রহণ
$search = isset($_GET['search']) ? trim($_GET['search']) : '';

// JSON হেডার সেট করা
header('Content-Type: application/json; charset=UTF-8');

// যদি ফাইলটি বিদ্যমান থাকে
if (file_exists($jsonFile)) {
    // ফাইলের তথ্য পড়ুন
    $data = file_get_contents($jsonFile);
    
    // JSON ডেটা ডিকোড করুন
    $donors = json_decode($data, true);
    
    if ($donors !== null) {
        // যদি search প্যারামিটার খালি না থাকে, তাহলে ফিল্টার করবো
        if (!empty($search)) {
            $search = strtolower($search); // সার্চ ক্যাস ইনসেনসিটিভ করার জন্য লোয়ারকেস
            $filteredDonors = array_filter($donors, function ($donor) use ($search) {
                // ডোনারের প্রতিটি ভ্যালু চেক করা
                foreach ($donor as $key => $value) {
                    if (stripos($value, $search) !== false) {
                        return true; // যদি ম্যাচ পায়, তাহলে এটি রিটার্ন হবে
                    }
                }
                return false;
            });

            // ফিল্টার করা ডাটা যদি থাকে তাহলে JSON রিটার্ন করবো
            if (count($filteredDonors) > 0) {
                echo json_encode([
                    "status" => "success",
                    "message" => "সফলভাবে তথ্য পাওয়া গেছে",
                    "data" => array_values($filteredDonors)
                ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            } else {
                echo json_encode([
                    "status" => "no_data",
                    "message" => "কোনো তথ্য পাওয়া যায়নি",
                    "data" => []
                ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
            }
        } else {
            // যদি search প্যারামিটার খালি থাকে, তাহলে সব ডেটা দেখাবো
            echo json_encode([
                "status" => "success",
                "message" => "সকল রক্তদাতার তথ্য দেখানো হচ্ছে",
                "data" => $donors
            ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        }
    } else {
        echo json_encode([
            "status" => "error",
            "message" => "ফাইলের ডেটা সঠিক JSON ফরম্যাটে নেই",
            "data" => []
        ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    }
} else {
    echo json_encode([
        "status" => "no_data",
        "message" => "কোনো রক্তদানকারী তথ্য পাওয়া যায়নি",
        "data" => []
    ], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
}
?>
