<?php
// রক্তদানকারীর তথ্য JSON ফাইলের পাথ
$jsonFile = 'blood_donors.json';

// নতুন রক্তদানকারীর তথ্য গ্রহণ
$name = isset($_GET['name']) ? trim($_GET['name']) : '';
$address = isset($_GET['address']) ? trim($_GET['address']) : '';
$bloodGroup = isset($_GET['bloodGroup']) ? trim($_GET['bloodGroup']) : '';
$hospital = isset($_GET['hospital']) ? trim($_GET['hospital']) : '';
$deviceId = isset($_GET['deviceId']) ? trim($_GET['deviceId']) : ''; // Device ID added 
$phonenumber = isset($_GET['phonenumber']) ? trim($_GET['phonenumber']) : '';

// ইনপুট যাচাই
if (empty($name) || empty($address) || empty($bloodGroup) || empty($hospital) || empty($deviceId) || empty($phonenumber)) {
    echo json_encode(array("status" => "failed", "message" => "নাম, ঠিকানা, রক্তের গ্রুপ, হাসপাতালের নাম, ডিভাইস আইডি এবং ফোন নম্বর প্রয়োজন"));
    exit;
}

// নতুন রক্তদানকারীর তথ্য তৈরি
$newDonor = array(
    'name' => $name,
    'address' => $address,
    'blood_group' => $bloodGroup,
    'hospital' => $hospital,
    'status' => 'Pending',
    'device_id' => $deviceId, 
    'phonenumber' => $phonenumber
);

// ফাইলটি যদি না থাকে, একটি নতুন ফাইল তৈরি করা হবে
if (!file_exists($jsonFile)) {
    file_put_contents($jsonFile, json_encode([])); // একটি খালি অ্যারে লিখুন
}

// ফাইল থেকে পুরানো তথ্য লোড করা
$existingData = json_decode(file_get_contents($jsonFile), true);

// নতুন রক্তদানকারী তথ্য অ্যারে-তে যোগ করা
array_push($existingData, $newDonor);

// নতুন তথ্য JSON ফাইলে আপডেট করা
if (file_put_contents($jsonFile, json_encode($existingData, JSON_PRETTY_PRINT))) {
    echo json_encode(array("status" => "success", "message" => "রক্তদানকারী সফলভাবে নিবন্ধিত"));
} else {
    echo json_encode(array("status" => "failed", "message" => "ডেটা আপডেট করতে ত্রুটি হয়েছে"));
}
?>
