document.getElementById('donorForm').addEventListener('submit', function(event) {
    event.preventDefault(); // Prevent form submission

    // Collect form data
    const formData = new FormData(this);
    const name = formData.get('name');
    const address = formData.get('address');
    const bloodGroup = formData.get('bloodGroup');
    const hospital = formData.get('hospital');
    const deviceId = formData.get('deviceId');
    const phonenumber = formData.get('phonenumber');

    // Construct the API URL with query parameters
    const url = `https://shitolkar.top/clint/bloodregi/registerBloodDonor.php?name=${encodeURIComponent(name)}&address=${encodeURIComponent(address)}&bloodGroup=${encodeURIComponent(bloodGroup)}&hospital=${encodeURIComponent(hospital)}&deviceId=${encodeURIComponent(deviceId)}&phonenumber=${encodeURIComponent(phonenumber)}`;

    // Send a GET request to the API
    fetch(url)
        .then(response => response.json())
        .then(data => {
            // Display success message
            document.getElementById('responseMessage').innerText = data.message || 'অজানা ত্রুটি!';
        })
        .catch(error => {
            // Display error message
            document.getElementById('responseMessage').innerText = 'ডেটা পাঠাতে ত্রুটি হয়েছে!';
            console.error('Error:', error);
        });
});
