<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

define("JSON_FILE", "police_data.json");

// JSON ফাইল থেকে ডাটা পড়ার ফাংশন
function readData() {
    if (!file_exists(JSON_FILE)) {
        file_put_contents(JSON_FILE, json_encode([]));
    }
    return json_decode(file_get_contents(JSON_FILE), true);
}

// JSON ফাইল-এ ডাটা সংরক্ষণ করার ফাংশন
function saveData($data) {
    file_put_contents(JSON_FILE, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

// অ্যাকশন চেক করা
$action = isset($_GET["action"]) ? $_GET["action"] : "";

$data = readData();

if ($action == "fetch") { 
    // 🔹 সব ডাটা দেখানো
    echo json_encode($data);

} elseif ($action == "search") { 
    // 🔹 নির্দিষ্ট তথ্য অনুসন্ধান
    $query = isset($_GET["query"]) ? $_GET["query"] : "";
    $filteredData = array_filter($data, function ($item) use ($query) {
        return stripos($item["name"], $query) !== false ||
               stripos($item["rank"], $query) !== false ||
               stripos($item["station"], $query) !== false ||
               stripos($item["district"], $query) !== false ||
               stripos($item["phone"], $query) !== false;
    });
    echo json_encode(array_values($filteredData));

} elseif ($action == "insert") { 
    // 🔹 নতুন তথ্য যোগ করা
    if (!isset($_GET["name"], $_GET["rank"], $_GET["station"], $_GET["district"], $_GET["phone"])) {
        echo json_encode(["error" => "Invalid input"]);
        exit;
    }

    $newData = [
        "name" => $_GET["name"],
        "rank" => $_GET["rank"],
        "station" => $_GET["station"],
        "district" => $_GET["district"],
        "phone" => $_GET["phone"]
    ];
    
    $data[] = $newData;
    saveData($data);

    echo json_encode(["success" => "Data added successfully"]);

} elseif ($action == "update") { 
    // 🔹 তথ্য আপডেট করা
    if (!isset($_GET["phone"])) {
        echo json_encode(["error" => "Phone number required for update"]);
        exit;
    }

    $updated = false;
    foreach ($data as &$item) {
        if ($item["phone"] == $_GET["phone"]) {
            if (isset($_GET["name"])) $item["name"] = $_GET["name"];
            if (isset($_GET["rank"])) $item["rank"] = $_GET["rank"];
            if (isset($_GET["station"])) $item["station"] = $_GET["station"];
            if (isset($_GET["district"])) $item["district"] = $_GET["district"];
            $updated = true;
            break;
        }
    }

    if ($updated) {
        saveData($data);
        echo json_encode(["success" => "Data updated successfully"]);
    } else {
        echo json_encode(["error" => "No record found with this phone number"]);
    }

} elseif ($action == "delete") { 
    // 🔹 তথ্য মুছে ফেলা
    if (!isset($_GET["phone"])) {
        echo json_encode(["error" => "Phone number required for delete"]);
        exit;
    }

    $filteredData = array_filter($data, function ($item) {
        return $item["phone"] !== $_GET["phone"];
    });

    if (count($data) == count($filteredData)) {
        echo json_encode(["error" => "No record found to delete"]);
    } else {
        saveData(array_values($filteredData));
        echo json_encode(["success" => "Data deleted successfully"]);
    }

} else {
    echo json_encode(["error" => "Invalid action"]);
}
?>
