<?php
function slugify($text) {
    return strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '_', $text)));
}

function loadCategories() {
    $file = 'data/categories.json';
    if (!file_exists($file)) file_put_contents($file, json_encode([], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
    return json_decode(file_get_contents($file), true);
}

function saveCategories($categories) {
    file_put_contents('data/categories.json', json_encode($categories, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}

function loadData($slug) {
    $file = "data/{$slug}.json";
    if (!file_exists($file)) return [];
    $json = json_decode(file_get_contents($file), true);
    return $json[$slug] ?? [];
}

function saveData($slug, $data) {
    file_put_contents("data/{$slug}.json", json_encode([$slug => $data], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT));
}
?>
